function Main

%% Note that the wavwrite seem to always produce "data clipped" warning messages!


close all
Fa=3500;

%% File 1: PS8Raw

file_in='PS8Raw.wav';
file_scr='PS8RawScrambled.wav';
file_dec='PS8RawDescrambled.wav';

[y, Fs, Nbits] = wavread(file_in); 
Fs
scr=encode_procedure(y,Fs,Nbits,file_scr,Fa)

decode_procedure(scr,Fs,Nbits,file_dec,Fa)

return
%
%% PS8Scrambled
file_scr='PS8Scrambled.wav';
file_dec='PS8Descrambled.wav';

[scr, Fs, Nbits] = wavread(file_scr); 
Fs
scr=decode_filt(scr,Fs);
decode_procedure(scr,Fs,Nbits,file_dec,Fa)


%%
function scr=encode_procedure(y,Fs,Nbits,file_scr,Fa)

sound(y, Fs);
mag_plot(y,Fs,'(1): Magnitude Spectrum of Original Audio')
y=audio_filt(y,Fs);
sound(audio_scale(y), Fs);

scr = encode(y,Fs,Fa);
scr=decode_filt(scr,Fs);
%sound(scr, Fs);
wavwrite(scr, Fs, Nbits, file_scr);

%%
function decode_procedure(scr,Fs,Nbits,file_dec,Fa) %Assume the pre-decode post filter is already done

dec = decode(scr, Fs, Fa);
dec=audio_filt(dec,Fs);
mag_plot(dec,Fs,'(6): Magnitude Spectrum of Audio Fitered Decoder Output')
dec=audio_scale(dec);
sound(dec, Fs);
wavwrite(dec, Fs, Nbits, file_dec);

%% 
function y_normalized=audio_scale(y)
% Audio play of double values assumes that values are in the range -1.0 <= y <= 1.0. 
% Values outside that range are clipped. 
% To avoid clipping we normalize our signal before playing it or storing it as audio file 
    
y_min=min(y);
y_max=max(y);

sc=max([1 y_max -abs(y_min)]);
y_normalized=y/sc;
%y_normalized=-1+2*(y-y_min)/(y_max-y_min); Other approach
